package demo.module;

import com.sun.jna.NativeLong;
import com.sun.jna.ptr.IntByReference;

import netsdk.lib.DeviceSdk;
import netsdk.lib.ToolKits;

/**
 * \if ENGLISH_LANG
 * Capture Picture Interface
 * contains:local、remote、timer and stop capture picture
 * \else
 * 抓图接口实现
 * 包含: 本地、远程、定时和停止抓图
 * \endif
 */
public class CapturePictureModule {

	/**
	 * \if ENGLISH_LANG
	 * Local Capture Picture
	 * \else
	 * 本地抓图
	 * \endif
	 */
	public static boolean localCapturePicture(NativeLong hPlayHandle, String picFileName) {				
		if (!LoginModule.netsdk.NET_SDK_CapturePicture(hPlayHandle, picFileName)) { 
			System.err.printf("CLIENT_CapturePicture Failed!" + ToolKits.getErrorCodePrint());
			return false;
		} else { 
			System.out.println("CLIENT_CapturePicture success"); 
		}
		return true;
	}
	
	/**
	 * \if ENGLISH_LANG
	 * Remote Capture Picture
	 * \else
	 * 远程抓图
	 * \endif
	 */
	public static boolean remoteCapturePicture(int chn, String picFileName) {
		return snapPicture(chn, picFileName);
	}
		
	
	/**
	 * \if ENGLISH_LANG
	 * Capture Picture (except local capture picture, others all call this interface)
	 * \else
	 * 抓图 (除本地抓图外, 其他全部调用此接口)
	 * \endif
	 */
	private static boolean snapPicture(int chn, String picFileName) {
//		if (!LoginModule.netsdk.NET_SDK_CapturePicture_Other(LoginModule.m_hLoginHandle, chn, picFileName)) { 
//			System.err.printf("CLIENT_SnapPictureEx Failed!" + ToolKits.getErrorCodePrint());
//			return false;
//		} else { 
//			System.out.println("CLIENT_SnapPictureEx success"); 
//		}
		return true;
	}
	
}
